 ; Ŀ
 ;   Bounce: removes all unreferenced blocks, layers, linetypes, views,    
 ;   etc. from a drawing, also kills all groups.                           
 ;   Copyright 1993, 1997, 1998, 2000, 2002, 2009 by Rocket Software Ltd.  
 ;   Rocket: when seconds count.  (Usually after a major screwup.)         
 ; 

 ; Ŀ
 ;   Subroutine Ball: wblock and reopen the current drawing.               
 ;   Takes no argument, returns nothing.                                   
 ;   This is the version for Sdi = 0, >1 document open.                    
 ; 
 (DEFUN BALL (/ nn fn)
  (command ".qsave")
  (setq nn (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (command ".wblock")
  (command nn)   ; file name
  (command "y")  ; exists, do you want to replace it?
  (command "*")  ; whole drawing
 ; Ŀ
 ;   Write the script file.  This won't work if the user doesn't have      
 ;   write access to his acad directory.                                   
 ; 
  (setq fn (strcat (car (spath (findfile "acad.exe"))) "ascript.scr"))
  (setq fn (open fn "w"))
  (write-line ".close" fn)
 ; Ŀ
 ;   Dbmod isn't changed by the wblock procedure.                          
 ;   Currently only 32 doesn't provoke a save on close question.           
 ; 
  (if (> (rem (getvar "dbmod") 32) 0)
      (write-line "n" fn))
  (write-line ".open" fn)
  (write-line (strcat "\"" nn "\"") fn)
  (close fn)
  (command "script" "ascript")
 (princ))
 ; Ŀ
 ;   Ball end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Bounce: wblock and reopen the current drawing.             
 ;   Takes no argument, returns nothing.                                   
 ;   This is for Sdi = 1, only one document can be open.                   
 ; 
 (DEFUN BOUNCE (/ nn)
  (setq nn (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (command "wblock")
  (command nn)
  (command "y")
  (command "*")
  (command "open")
  (if (> (rem (getvar "dbmod") 32) 0)
      (command "y"))
  (command nn)
 (princ))
 ; Ŀ
 ;   Bounce end.                                                           
 ; 

 ; Ŀ
 ;   Contx - Find all referenced xref definitions in the block tables.     
 ;   Takes no arguments.                                                   
 ;   Returns a list of lists: ((Blockname Filename)...)                    
 ; 
 (DEFUN CONTX (/ rew bldat sevnt namlst)
  (setq rew t)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq sevnt (cdr (assoc 70 bldat)))
         (if (= 4 (logand 4 sevnt))
             (setq namlst (append namlst (list (list (cdr (assoc 2 bldat))
                                                   (cdr (assoc 1 bldat))))))))
 namlst)
 ; Ŀ
 ;   Contx end.                                                            
 ; 

 ; Ŀ
 ;   Spath - split a path and filename string into a path and a filename.  
 ; 
 (DEFUN SPATH (tt / pos pp)
 ; Ŀ
 ;   Set the pointer Pos to the end of the string.                         
 ; 
  (setq pos (strlen tt))                            ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq pp (substr tt 1 pos))      ; then set pp to all before
                   (setq tt (substr tt (1+ pos)))   ;          tt to all after
                   (setq pos 1)))                   ;      and pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 (list pp tt))
 ; Ŀ
 ;   Spath end.                                                            
 ; 

 ; Ŀ
 ;   Bounce.                                                               
 ; 
 (DEFUN C:BOUNCE (/ sdip xrefp insp)
  (setq sdip (if (= (getvar "sdi") 1) T ()))
 ; Ŀ
 ;   This part has been commented out - bounce doesn't kill xrefs.         
 ;   This probably hasn't been a problem for about five versions.          
 ; 
;  (setq xrefp (contx))
;  (if xrefp
;      (progn
;           (initget 0 "Yes No")
;           (Setq insp
;                   (getkword "This drawing contains Xrefs.  Continue? <N>: "))
;           (if (= insp "Yes") (setq xrefp ()))))
;  (if (null xrefp)
;      (if sdip
;          (bounce)
;          (ball)))
 ; Ŀ
 ;   Back in reality...                                                    
 ; 
  (if sdip
      (bounce)
      (ball))
 (princ))